function [data] = join_counts(pathname_tmp)
%This function takes asks you to open a bunch of count files from
%savpivots and it will collate them all together as one file.
%Synatax:   [data] = join_counts();
%Input:     pathname_tmp = the directory of the files
%Output:    data = the joined data set, with each properties represented as
%               a single slice of the matrix.

if nargin==0
    prompt_box('title','Open Count Data','prompt1','Select the count folder you want to combine.','position','center');
    pause(0.25);
%     [filename_tmp,pathname_tmp,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.xlsx','Excel 2007 files (*.xlsx)';...
%         '*.xls','Excel files (*.xls)';'*.*','All Files';},...
%         'Open Count Files','Multiselect','on');
    pathname_tmp = uigetdir2('','Directory where the files are located');    %get the directory
end
%get the file names
dir_info = dir(pathname_tmp);
idx = [dir_info.isdir];   %grab all of the isdir numbers
names_tmp = {dir_info.name};   %grab the all of the names in the root
filename_tmp = names_tmp(~idx);    %the directory names in root

data = [];
str_data = [];
num_data = [];
str_label = [];

%Now open the data sets according to the filter used.
for i = 1:size(filename_tmp,2)
    %verti_tmp{i} = single(dlmread([pathname_tmp,filename_tmp{1,i}],','));
    %verti_tmp = single(dlmread([pathname_tmp,filename_tmp{1,i}],',',1,0));
    %verti_tmp = reshape(verti_tmp,size(verti_tmp,1),1,size(verti_tmp,2));   %rotate the array into a z array.
    fid = fopen([pathname_tmp filesep filename_tmp{i}]);  %open the file for scanning
    filenames{i} = strtrim(filename_tmp{i}(1:end-4));
    data_tmp = textscan(fid,'%s %d16','Delimiter',',','Headerlines',1);     %comma delimited files, with two columns, the the 1 string, 2 num
    %we need make sure that each added column is the same size
    if i==1     %first time through
        data_size = size(data_tmp{1,1},1); %initiate
    end
    str_tmp = cell(data_size,1);
    num_tmp = zeros(data_size,1);
    str_tmp(1:size(data_tmp{1,1}),:) = data_tmp{1,1};    %grab the string headers
    num_tmp(1:size(data_tmp{1,1}),:) = data_tmp{1,2};    %grab the numeric values associated with the string
    str_label = vertcat(str_label,data_tmp{1,1}); %Use this variable to create a unique list of field names
    if size(str_data,1)<size(str_tmp,1)     %more fields than already there, resize the array, not elegant, but works
        str_cache = cell(size(str_data,1)+(size(str_tmp,1)-size(str_data,1)),size(str_data,2));     %new sizes
        num_cache = zeros(size(str_data,1)+(size(str_tmp,1)-size(str_data,1)),size(str_data,2));
        str_cache(1:size(str_data,1),1:size(str_data,2)) = str_data(:,:);   %put old data back
        num_cache(1:size(num_data,1),1:size(num_data,2)) = num_data(:,:);
        str_data = str_cache;   %recast the variable
        num_data = num_cache;
        data_size = size(str_data,1);   %re-store
    end
    str_data = horzcat(str_data,str_tmp);       %join the data for later sorting, my current way all you need is to vertcat everything
    num_data = horzcat(num_data,num_tmp);        %ditto
    %str_data = vertcat(str_data,str_tmp);       %join the data for later sorting, my current way all you need is to vertcat everything
    %num_data = vertcat(num_data,num_tmp);        %ditto    Good idea but not quite
    %close file, necessary because of OS file open limitations
    fclose(fid);
end

%sort the data for output
str_label = unique(str_label);  %an unique set of field labesl
% for l = 1:size(str_data,2)   %go through and sort the data set
%     for m = 1:size(str_data,1)
%         field_tmp = str_data(m,l);  %grab the current field
%         for k = 1:size(str_label,1);     %go through the fields and sort
%             if strcmpi(str_label(k,1),field_tmp) %if there is a match (case insensitive now)
%                 data(k,l) = num_data(m,l);  %put the data in the right place
%             end
%         end
%     end
% end
for k = 1:size(str_label,1);     %go through the fields and sort
    data_loci =  strcmpi(str_label(k,1),str_data);  %find the data location(case insensitive now)
    if sum(sum(data_loci))~=size(data_loci,2)   %there are empty columns
        empty_loci = find(sum(data_loci)==0);   %which columns are empty
        data_loci(end,empty_loci) = 1;      %set empty columns to be true at the base of the column with will always be 0 in our setup.
    end
    data(k,:) = num_data(data_loci);  %put the data in the right place
end

%now save out the data file
data_out = dataset({data,filenames{:}},'ObsNames',str_label);
sav2csv(data_out,'joined_counts.csv',pathname_tmp);